//
//  AppDelegate.m
//  CQAdDemo
//
//  Created by bell on 2021/9/27.
//

#import "AppDelegate.h"
#import <CQAdSDK/CQAdSDK.h>
#import "ViewController.h"
#import <AppTrackingTransparency/AppTrackingTransparency.h>

#define kScreenWidth [[UIApplication sharedApplication]keyWindow].bounds.size.width
#define kScreenHeight [[UIApplication sharedApplication]keyWindow].bounds.size.height

#define IPHONEX_TABBAR_FIX_HEIGHT 34
#define IPHONEX_TOPBAR_FIX_HEIGHT 44
#define ISIPHONEX (([[UIApplication sharedApplication] statusBarFrame].size.height == 44) || ([UIScreen mainScreen].bounds.size.height == 812 || [UIScreen mainScreen].bounds.size.height == 896) || ([UIScreen mainScreen].bounds.size.width == 812 || [UIScreen mainScreen].bounds.size.width == 896))


@interface AppDelegate () <CQAdSplashAdDelegate>

@property (nonatomic, strong) CQAdSplashAd* splashAd;

@property (nonatomic, strong) UIView* splashBgView;

@end

@implementation AppDelegate

-(void)applicationDidBecomeActive:(UIApplication *)application
{
    [self ATTrackingAuthorizationIDFA];
}

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions 
{

    self.window = [[UIWindow alloc] initWithFrame:UIScreen.mainScreen.bounds];
    UINavigationController* navi = [[UINavigationController alloc] initWithRootViewController:ViewController.new];
    self.window.rootViewController = navi;
    
    [self.window makeKeyAndVisible];
    
    
    [self setupAdSdk];
    
    [self loadSplash];
    

    return YES;
}

- (void)setupAdSdk
{
    NSString *version = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"];
    [CQAdSDKConfig config:@"300065" mediaVersion:version];
    
    [CQAdSDKConfig setCustomUserId:@"xxxxxxxxxxxxxxx"];
    
    NSLog(@"version = %@", CQAdSDKConfig.version);
#if DEBUG
    [CQAdSDKConfig setDebug:YES];
#endif
}

- (void)loadSplash
{
    UIView* bottomView = [self bottomView];
    
    UIWindow* window = [[UIApplication.sharedApplication delegate] window];
    self.splashBgView = [[UIView alloc] initWithFrame:window.bounds];
    self.splashBgView.backgroundColor = UIColor.whiteColor;
    [window addSubview:self.splashBgView];
    
    CQAdSplashAd* splashAd = [[CQAdSplashAd alloc] initWithPlacementId:@"1000015462" window:window bottomView:nil timeout:6];

    splashAd.delegate = self;
    [splashAd loadAd];
    self.splashAd = splashAd;
}

- (UIView*)bottomView
{
    CGFloat h = 120;
    if (ISIPHONEX) 
    {
        h += IPHONEX_TABBAR_FIX_HEIGHT;
    }
    
    UIView* bottomView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, h)];
    bottomView.backgroundColor = [UIColor whiteColor];
    UIImage* logoImage = [UIImage imageNamed:@"logo"];
    UIImageView* imageView = [[UIImageView alloc] initWithImage:logoImage];
    CGRect frame = imageView.frame;
    frame.origin.x = (kScreenWidth - frame.size.width) / 2;
    imageView.frame = frame;
    [bottomView addSubview:imageView];
    
    return bottomView;
}

#pragma mark delegate

- (void)cqAdSplashAdLoadSuccess:(CQAdSplashAd*)splashAd
{
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdLoadSuccess");
    [splashAd showAd];
}

- (void)cqAdSplashAdLoadFailed:(CQAdSplashAd*)splashAd error:(NSError*)error
{
    [self.splashBgView removeFromSuperview];
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdLoadFailed error=%@", error);
}

- (void)cqAdSplashAdDidClick:(CQAdSplashAd*)splashAd
{
    [self.splashBgView removeFromSuperview];
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdDidClick");
}

- (void)cqAdSplashAdDidClose:(CQAdSplashAd *)splashAd
{
    [self.splashBgView removeFromSuperview];
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdDidClose");
}

- (void)cqAdSplashAdVisible:(CQAdSplashAd *)splashAd
{
    NSLog(@"CQAdSDKLog:CQAdSplashAd:cqAdSplashAdVisible");
}


- (void)ATTrackingAuthorizationIDFA {
    
    if (@available(iOS 14, *)) {
        ATTrackingManagerAuthorizationStatus trackingAuthorizationStatus =  ATTrackingManager.trackingAuthorizationStatus;
        switch (trackingAuthorizationStatus) {
            case ATTrackingManagerAuthorizationStatusNotDetermined:
            {
                [self requestTrackingAuthorization];
            }
                break;
            default:
                break;
        }
    }
}

- (void)requestTrackingAuthorization
{
    if (@available(iOS 14, *)) {
        [ATTrackingManager requestTrackingAuthorizationWithCompletionHandler:^(ATTrackingManagerAuthorizationStatus status) {
        }];
    }
}
@end
